<?php

namespace Modules\CMS\App\Services;

use App\Enums\ArticleLangDataTypeEnum;
use App\Repositories\Interfaces\ArticleDataRepositoryInterface;
use App\Repositories\Interfaces\ArticleLangDataRepositoryInterface;
use App\Repositories\Interfaces\ArticleRepositoryInterface;
use Exception;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\DB;

class CMSB2XCalculatorHeaderService
{
    /**
     * CMSB2XCalculatorHeaderService constructor.
     *
     */
    public function __construct(
        protected ArticleRepositoryInterface $articleRepository,
        protected ArticleDataRepositoryInterface $articleDataRepository,
        protected ArticleLangDataRepositoryInterface $articleLangDataRepository,
    ) {
    }

    /**
     * Update CMS b2x loan banner
     *
     * @param  array  $attributes
     * @return bool
     * @throws Exception
     */
    public function update(array $attributes): bool
    {
        $articleId = $attributes['article_id'];

        try {
            DB::beginTransaction();

            $articleUpdateData = [
                'article_name' => $attributes['b2x_calculator_header'],
                'status'       => $attributes['calculator_header_status'],
            ];

            $articleUpdateCheck = $this->articleRepository->updateById($articleId, $articleUpdateData);

            if ($articleUpdateCheck) {
                /**
                 * Article Lang Data insert start
                 */
                $articleLangDataInsertData = [
                    [
                        'article_id'    => $articleId,
                        'language_id'   => $attributes['calculator_header_language_id'],
                        'slug'          => ArticleLangDataTypeEnum::B2X_CALCULATOR_HEADER_TITLE->value,
                        'small_content' => $attributes['b2x_calculator_header_title'],
                    ],
                    [
                        'article_id'    => $articleId,
                        'language_id'   => $attributes['calculator_header_language_id'],
                        'slug'          => ArticleLangDataTypeEnum::B2X_CALCULATOR_HEADER_CONTENT->value,
                        'small_content' => $attributes['b2x_calculator_header_content'],
                    ],
                    [
                        'article_id'    => $articleId,
                        'language_id'   => $attributes['calculator_header_language_id'],
                        'slug'          => ArticleLangDataTypeEnum::B2X_LOAN_DETAILS_HEADER_TITLE->value,
                        'small_content' => $attributes['b2x_loan_details_header_title'],
                    ],
                    [
                        'article_id'    => $articleId,
                        'language_id'   => $attributes['calculator_header_language_id'],
                        'slug'          => ArticleLangDataTypeEnum::B2X_LOAN_BUTTON_TEXT->value,
                        'small_content' => $attributes['b2x_loan_button_text'],
                    ],
                ];

                foreach ($articleLangDataInsertData as $data) {
                    $articleLangData = $this->articleLangDataRepository->first(['article_id' => $articleId, 'slug' => $data['slug'], 'language_id' => $data['language_id']]);

                    if ($articleLangData) {
                        $this->articleLangDataRepository->updateById($articleLangData->id, $data);
                    } else {
                        $this->articleLangDataRepository->create($data);
                    }

                }

                /**
                 * Article Lang Data insert end
                 */
            }

            DB::commit();

            return true;

        } catch (Exception $exception) {

            DB::rollBack();

            throw new HttpResponseException(response()->json([
                'success' => false,
                'message' => localize("B2X Calculator Header update error"),
                'title'   => localize('B2X Calculator Header'),
                'errors'  => $exception,
            ], 422));
        }

    }

}
