@php
    use App\Enums\CustomerStatusEnum;
    use App\Enums\CustomerVerifyStatusEnum;
@endphp

<div class="user-profile-header d-flex flex-column flex-sm-row text-sm-start text-center mb-4">
    <div class="flex-shrink-0 mt-n2 mx-sm-0 mx-auto mt-4">
        <img src="{{ $customer['avatar'] ? storage_asset($customer['avatar']) : assets('img/noimage.jpg') }}"
            alt="user image" class="d-block h-auto ms-0 ms-sm-4 rounded user-profile-img" />
    </div>
    <div class="flex-grow-1 mt-3 mt-sm-5">
        <div
            class="d-flex align-items-md-end align-items-sm-start align-items-center justify-content-md-between justify-content-start mx-4 flex-md-row flex-column gap-4">
            <div class="user-profile-info">
                <h4 class="fs-20 fw-medium">{{ $customer['first_name'] . ' ' . $customer['last_name'] }}</h4>
                <ul
                    class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-2">
                    <li class="list-inline-item">
                        <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M3.38118 7.29473e-07H9.61882C10.0471 -1.44454e-05 10.4166 -2.76752e-05 10.721 0.0259857C11.0422 0.0534408 11.3617 0.114057 11.6691 0.277942C12.1277 0.522394 12.5007 0.91249 12.7344 1.39241C12.891 1.714 12.9489 2.04821 12.9752 2.38422C13 2.70261 13 3.08915 13 3.53722V13.4628C13 13.9108 13 14.2974 12.9752 14.6158C12.9489 14.9518 12.891 15.286 12.7343 15.6076C12.5007 16.0875 12.1277 16.4776 11.6691 16.7221C11.3617 16.8859 11.0422 16.9466 10.721 16.974C10.4166 17 10.0471 17 9.61883 17H3.38117C2.95286 17 2.58337 17 2.27903 16.974C1.95785 16.9466 1.63838 16.8859 1.33098 16.7221C0.872233 16.4776 0.499347 16.0875 0.26568 15.6077C0.109025 15.2861 0.0510831 14.9518 0.0248393 14.6158C-2.64553e-05 14.2974 -1.38081e-05 13.9108 6.9729e-07 13.4628V3.53724C-1.38081e-05 3.08916 -2.64531e-05 2.70261 0.0248395 2.38422C0.0510839 2.04819 0.109027 1.71396 0.265668 1.39234M2.41137 1.72034C2.19064 1.73921 2.10881 1.77123 2.06864 1.79264C1.91577 1.87413 1.79146 2.00416 1.71357 2.16409C1.6931 2.20612 1.66248 2.29175 1.64444 2.52266C1.62563 2.7635 1.625 3.07993 1.625 3.57V13.43C1.625 13.9201 1.62563 14.2365 1.64444 14.4774C1.66248 14.7083 1.69309 14.7939 1.71355 14.8359C1.79146 14.9958 1.91577 15.1259 2.06856 15.2073C2.10873 15.2287 2.19065 15.2608 2.41137 15.2797C2.64158 15.2993 2.94405 15.3 3.4125 15.3H9.5875C10.0559 15.3 10.3584 15.2993 10.5886 15.2797C10.8094 15.2608 10.8912 15.2288 10.9313 15.2074C11.0842 15.1259 11.2086 14.9958 11.2864 14.836C11.3069 14.794 11.3375 14.7083 11.3556 14.4774C11.3744 14.2365 11.375 13.9201 11.375 13.43V3.57C11.375 3.07993 11.3744 2.7635 11.3556 2.52267C11.3375 2.29176 11.3069 2.20615 11.2864 2.16413C11.2086 2.00429 11.0843 1.87415 10.9314 1.79264C10.8912 1.77124 10.8094 1.73921 10.5886 1.72034C10.3584 1.70066 10.0559 1.7 9.5875 1.7H3.4125C2.94405 1.7 2.64158 1.70066 2.41137 1.72034ZM4.0625 3.4C4.0625 2.93056 4.42627 2.55 4.875 2.55H8.125C8.57373 2.55 8.9375 2.93056 8.9375 3.4C8.9375 3.86944 8.57373 4.25 8.125 4.25H4.875C4.42627 4.25 4.0625 3.86944 4.0625 3.4ZM4.875 7.65C4.875 6.7111 5.60253 5.95 6.5 5.95C7.39748 5.95 8.125 6.7111 8.125 7.65C8.125 8.5889 7.39748 9.35 6.5 9.35C5.60253 9.35 4.875 8.5889 4.875 7.65ZM3.274 12.545C3.6166 11.103 5.02368 10.2 6.5 10.2C7.9763 10.2 9.38345 11.103 9.72601 12.545C9.83424 13.0006 9.56895 13.4617 9.13347 13.5749C8.69799 13.6881 8.25722 13.4106 8.14899 12.955C8.0307 12.4571 7.43033 11.9 6.5 11.9C5.56969 11.9 4.96932 12.4571 4.85101 12.955C4.74276 13.4106 4.30198 13.6881 3.8665 13.5749C3.43102 13.4617 3.16575 13.0005 3.274 12.545Z"
                                fill="#9B9B9B" />
                        </svg>
                        <span class="fs-16 fw-normal">{{ localize('ID') }} : {{ $customer['user_id'] }}</span>
                    </li>
                    <li class="list-inline-item">
                        <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M4.25 0C4.71944 0 5.1 0.380558 5.1 0.85V1.7H11.9V0.85C11.9 0.380558 12.2806 0 12.75 0C13.2194 0 13.6 0.380558 13.6 0.85V1.70002C13.9902 1.70026 14.3304 1.70267 14.6158 1.72598C14.9518 1.75344 15.2861 1.81406 15.6077 1.97794C16.0874 2.22238 16.4776 2.61243 16.722 3.0923L16.7221 3.0924C16.8859 3.414 16.9466 3.74821 16.974 4.08422C17 4.4026 17 4.78915 17 5.23722V13.4628C17 13.9108 17 14.2974 16.974 14.6158C16.9466 14.9518 16.8859 15.286 16.7221 15.6076C16.4776 16.0875 16.0875 16.4776 15.6076 16.7221C15.286 16.8859 14.9518 16.9466 14.6158 16.974C14.2974 17 13.9108 17 13.4628 17H3.53722C3.08915 17 2.70261 17 2.38422 16.974C2.04821 16.9466 1.714 16.8859 1.39241 16.7221C0.91249 16.4776 0.522394 16.0875 0.277942 15.6077C0.114057 15.2861 0.0534408 14.9518 0.0259857 14.6158C-2.76747e-05 14.2974 -1.44454e-05 13.9108 7.29473e-07 13.4628V5.23724C-1.44454e-05 4.78916 -2.76747e-05 4.40261 0.0259859 4.08422C0.0534416 3.74819 0.114059 3.41396 0.277929 3.09234M1.7 6.8V13.43C1.7 13.9201 1.70066 14.2365 1.72034 14.4774C1.73921 14.7083 1.77124 14.7939 1.79264 14.8359C1.87414 14.9958 2.00419 15.1259 2.16403 15.2073L2.16413 15.2074C2.20615 15.2288 2.29175 15.2608 2.52266 15.2797C2.7635 15.2993 3.07993 15.3 3.57 15.3H13.43C13.9201 15.3 14.2365 15.2993 14.4773 15.2797C14.7083 15.2608 14.7939 15.2288 14.8359 15.2074L14.836 15.2073C14.9958 15.1259 15.1259 14.9958 15.2073 14.836L15.2074 14.8359C15.2288 14.7939 15.2608 14.7083 15.2797 14.4773C15.2993 14.2365 15.3 13.9201 15.3 13.43V6.8H1.7ZM15.2999 5.1H1.70006C1.70044 4.70466 1.70304 4.43443 1.72034 4.22266C1.73921 3.99175 1.77123 3.90614 1.79264 3.86412C1.87413 3.70419 2.00416 3.57414 2.16409 3.49265C2.20612 3.47124 2.29175 3.4392 2.52266 3.42034C2.7635 3.40066 3.07993 3.4 3.57 3.4H13.43C13.9201 3.4 14.2365 3.40066 14.4774 3.42034C14.7083 3.43921 14.7939 3.47123 14.8359 3.49264C14.9958 3.57414 15.1259 3.70418 15.2073 3.86403L15.2074 3.86413C15.2288 3.90615 15.2608 3.99175 15.2797 4.22266C15.297 4.43443 15.2996 4.70466 15.2999 5.1ZM3.4 9.34988C3.40007 8.88044 3.78068 8.49993 4.25012 8.5L12.7501 8.50119C13.2196 8.50126 13.6001 8.88187 13.6 9.35131C13.5999 9.82075 13.2193 10.2013 12.7499 10.2012L4.24988 10.2C3.78044 10.1999 3.39994 9.81932 3.4 9.34988ZM3.4 12.7499C3.40007 12.2804 3.78069 11.8999 4.25013 11.9L7.08343 11.9004C7.55287 11.9005 7.93338 12.2811 7.93331 12.7506C7.93324 13.22 7.55262 13.6005 7.08318 13.6004L4.24987 13.6C3.78043 13.5999 3.39993 13.2193 3.4 12.7499Z"
                                fill="#9B9B9B" />
                        </svg>
                        <span class="fs-16 fw-normal">{{ localize('Joined') }} :
                            {{ get_ymd($customer['created_at']) }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="card shadow-one mb-3">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-4">
                        <p class="mb-3 fs-16 fw-medium">{{ localize('About') }}</p>
                        <ul class="list-unstyled mb-4">
                            <li class="d-flex align-items-center mb-3">
                                <svg width="14" height="16" viewBox="0 0 14 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.5 7C5.80777 7 5.13108 6.79473 4.55551 6.41014C3.97993 6.02556 3.53133 5.47893 3.26642 4.83939C3.00152 4.19985 2.9322 3.49612 3.06725 2.81719C3.2023 2.13825 3.53564 1.51461 4.02513 1.02513C4.51461 0.535644 5.13825 0.202301 5.81719 0.0672531C6.49612 -0.0677952 7.19985 0.00151649 7.83939 0.266423C8.47893 0.53133 9.02556 0.979934 9.41014 1.55551C9.79473 2.13108 10 2.80777 10 3.5C10 4.42826 9.63125 5.3185 8.97487 5.97487C8.3185 6.63125 7.42826 7 6.5 7ZM6.5 1.4C6.08466 1.4 5.67865 1.52316 5.3333 1.75391C4.98796 1.98467 4.7188 2.31264 4.55985 2.69637C4.40091 3.08009 4.35932 3.50233 4.44035 3.90969C4.52138 4.31705 4.72139 4.69123 5.01508 4.98492C5.30877 5.27861 5.68295 5.47862 6.09031 5.55965C6.49767 5.64068 6.91991 5.59909 7.30364 5.44015C7.68736 5.2812 8.01534 5.01204 8.24609 4.6667C8.47684 4.32136 8.6 3.91534 8.6 3.5C8.6 2.94305 8.37875 2.4089 7.98493 2.01508C7.5911 1.62125 7.05696 1.4 6.5 1.4Z"
                                        fill="#A1A1A1" />
                                    <path
                                        d="M13.3 16H0.7C0.514348 16 0.336301 15.9298 0.205025 15.8047C0.0737498 15.6797 0 15.5101 0 15.3333V13.3333C0 11.9188 0.589998 10.5623 1.6402 9.5621C2.69041 8.5619 4.11479 8 5.6 8H8.4C9.88521 8 11.3096 8.5619 12.3598 9.5621C13.41 10.5623 14 11.9188 14 13.3333V15.3333C14 15.5101 13.9263 15.6797 13.795 15.8047C13.6637 15.9298 13.4857 16 13.3 16ZM1.4 14.6667H12.6V13.3333C12.6 12.2725 12.1575 11.2551 11.3698 10.5049C10.5822 9.75476 9.51391 9.33333 8.4 9.33333H5.6C4.48609 9.33333 3.4178 9.75476 2.63015 10.5049C1.8425 11.2551 1.4 12.2725 1.4 13.3333V14.6667Z"
                                        fill="#A1A1A1" />
                                </svg>
                                <span class="mx-2">{{ localize('Full Name') }}:</span>
                                <span>{{ $customer['first_name'] . ' ' . $customer['last_name'] }}</span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <svg width="14" height="16" viewBox="0 0 14 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.5 7C5.80777 7 5.13108 6.79473 4.55551 6.41014C3.97993 6.02556 3.53133 5.47893 3.26642 4.83939C3.00152 4.19985 2.9322 3.49612 3.06725 2.81719C3.2023 2.13825 3.53564 1.51461 4.02513 1.02513C4.51461 0.535644 5.13825 0.202301 5.81719 0.0672531C6.49612 -0.0677952 7.19985 0.00151649 7.83939 0.266423C8.47893 0.53133 9.02556 0.979934 9.41014 1.55551C9.79473 2.13108 10 2.80777 10 3.5C10 4.42826 9.63125 5.3185 8.97487 5.97487C8.3185 6.63125 7.42826 7 6.5 7ZM6.5 1.4C6.08466 1.4 5.67865 1.52316 5.3333 1.75391C4.98796 1.98467 4.7188 2.31264 4.55985 2.69637C4.40091 3.08009 4.35932 3.50233 4.44035 3.90969C4.52138 4.31705 4.72139 4.69123 5.01508 4.98492C5.30877 5.27861 5.68295 5.47862 6.09031 5.55965C6.49767 5.64068 6.91991 5.59909 7.30364 5.44015C7.68736 5.2812 8.01534 5.01204 8.24609 4.6667C8.47684 4.32136 8.6 3.91534 8.6 3.5C8.6 2.94305 8.37875 2.4089 7.98493 2.01508C7.5911 1.62125 7.05696 1.4 6.5 1.4Z"
                                        fill="#A1A1A1" />
                                    <path
                                        d="M13.3 16H0.7C0.514348 16 0.336301 15.9298 0.205025 15.8047C0.0737498 15.6797 0 15.5101 0 15.3333V13.3333C0 11.9188 0.589998 10.5623 1.6402 9.5621C2.69041 8.5619 4.11479 8 5.6 8H8.4C9.88521 8 11.3096 8.5619 12.3598 9.5621C13.41 10.5623 14 11.9188 14 13.3333V15.3333C14 15.5101 13.9263 15.6797 13.795 15.8047C13.6637 15.9298 13.4857 16 13.3 16ZM1.4 14.6667H12.6V13.3333C12.6 12.2725 12.1575 11.2551 11.3698 10.5049C10.5822 9.75476 9.51391 9.33333 8.4 9.33333H5.6C4.48609 9.33333 3.4178 9.75476 2.63015 10.5049C1.8425 11.2551 1.4 12.2725 1.4 13.3333V14.6667Z"
                                        fill="#A1A1A1" />
                                </svg>
                                <span class="mx-2">{{ localize('User Name') }}:</span>
                                <span>{{ $customer['username'] }}</span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M3.38118 7.29473e-07H9.61882C10.0471 -1.44454e-05 10.4166 -2.76752e-05 10.721 0.0259857C11.0422 0.0534408 11.3617 0.114057 11.6691 0.277942C12.1277 0.522394 12.5007 0.91249 12.7344 1.39241C12.891 1.714 12.9489 2.04821 12.9752 2.38422C13 2.70261 13 3.08915 13 3.53722V13.4628C13 13.9108 13 14.2974 12.9752 14.6158C12.9489 14.9518 12.891 15.286 12.7343 15.6076C12.5007 16.0875 12.1277 16.4776 11.6691 16.7221C11.3617 16.8859 11.0422 16.9466 10.721 16.974C10.4166 17 10.0471 17 9.61883 17H3.38117C2.95286 17 2.58337 17 2.27903 16.974C1.95785 16.9466 1.63838 16.8859 1.33098 16.7221C0.872233 16.4776 0.499347 16.0875 0.26568 15.6077C0.109025 15.2861 0.0510831 14.9518 0.0248393 14.6158C-2.64553e-05 14.2974 -1.38081e-05 13.9108 6.9729e-07 13.4628V3.53724C-1.38081e-05 3.08916 -2.64531e-05 2.70261 0.0248395 2.38422C0.0510839 2.04819 0.109027 1.71396 0.265668 1.39234M2.41137 1.72034C2.19064 1.73921 2.10881 1.77123 2.06864 1.79264C1.91577 1.87413 1.79146 2.00416 1.71357 2.16409C1.6931 2.20612 1.66248 2.29175 1.64444 2.52266C1.62563 2.7635 1.625 3.07993 1.625 3.57V13.43C1.625 13.9201 1.62563 14.2365 1.64444 14.4774C1.66248 14.7083 1.69309 14.7939 1.71355 14.8359C1.79146 14.9958 1.91577 15.1259 2.06856 15.2073C2.10873 15.2287 2.19065 15.2608 2.41137 15.2797C2.64158 15.2993 2.94405 15.3 3.4125 15.3H9.5875C10.0559 15.3 10.3584 15.2993 10.5886 15.2797C10.8094 15.2608 10.8912 15.2288 10.9313 15.2074C11.0842 15.1259 11.2086 14.9958 11.2864 14.836C11.3069 14.794 11.3375 14.7083 11.3556 14.4774C11.3744 14.2365 11.375 13.9201 11.375 13.43V3.57C11.375 3.07993 11.3744 2.7635 11.3556 2.52267C11.3375 2.29176 11.3069 2.20615 11.2864 2.16413C11.2086 2.00429 11.0843 1.87415 10.9314 1.79264C10.8912 1.77124 10.8094 1.73921 10.5886 1.72034C10.3584 1.70066 10.0559 1.7 9.5875 1.7H3.4125C2.94405 1.7 2.64158 1.70066 2.41137 1.72034ZM4.0625 3.4C4.0625 2.93056 4.42627 2.55 4.875 2.55H8.125C8.57373 2.55 8.9375 2.93056 8.9375 3.4C8.9375 3.86944 8.57373 4.25 8.125 4.25H4.875C4.42627 4.25 4.0625 3.86944 4.0625 3.4ZM4.875 7.65C4.875 6.7111 5.60253 5.95 6.5 5.95C7.39748 5.95 8.125 6.7111 8.125 7.65C8.125 8.5889 7.39748 9.35 6.5 9.35C5.60253 9.35 4.875 8.5889 4.875 7.65ZM3.274 12.545C3.6166 11.103 5.02368 10.2 6.5 10.2C7.9763 10.2 9.38345 11.103 9.72601 12.545C9.83424 13.0006 9.56895 13.4617 9.13347 13.5749C8.69799 13.6881 8.25722 13.4106 8.14899 12.955C8.0307 12.4571 7.43033 11.9 6.5 11.9C5.56969 11.9 4.96932 12.4571 4.85101 12.955C4.74276 13.4106 4.30198 13.6881 3.8665 13.5749C3.43102 13.4617 3.16575 13.0005 3.274 12.545Z"
                                        fill="#9B9B9B" />
                                </svg>
                                <span class="mx-2">{{ localize('User ID') }} :</span>
                                <span>{{ $customer['user_id'] }}</span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M5.14919 4.02958C5.76743 4.02958 6.26859 3.47829 6.26859 2.79824C6.26859 2.11818 5.76743 1.56689 5.14919 1.56689C4.53096 1.56689 4.02979 2.11818 4.02979 2.79824C4.02979 3.47829 4.53096 4.02958 5.14919 4.02958ZM5.14919 3.22921C5.36557 3.22921 5.54098 3.03626 5.54098 2.79824C5.54098 2.56022 5.36557 2.36727 5.14919 2.36727C4.93281 2.36727 4.7574 2.56022 4.7574 2.79824C4.7574 3.03626 4.93281 3.22921 5.14919 3.22921Z"
                                        fill="#A1A1A1" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M2.39423 2.66924C2.39423 1.16556 3.67727 0 5.19231 0C6.70737 0 7.99038 1.16556 7.99038 2.66924C7.99038 2.9193 7.96812 3.19343 7.91937 3.48218L9.80769 3.957L14.2832 2.83164C14.4555 2.7883 14.6381 2.82725 14.7781 2.93721C14.9181 3.04718 15 3.2159 15 3.39458V13.2592C15 13.5254 14.8198 13.7575 14.563 13.8221L9.9476 14.9827C9.85575 15.0058 9.75963 15.0058 9.66779 14.9827L5.19231 13.8573L0.71685 14.9827C0.544494 15.026 0.361904 14.9871 0.221879 14.8771C0.0818481 14.7671 0 14.5984 0 14.4197V4.55512C0 4.28885 0.180173 4.05676 0.436996 3.99218L2.46525 3.48218C2.41652 3.19343 2.39423 2.9193 2.39423 2.66924ZM5.19231 0.986457C4.15834 0.986457 3.375 1.76937 3.375 2.66924C3.375 3.58665 3.75721 4.94588 4.8518 5.97778C5.0437 6.1587 5.34092 6.1587 5.53281 5.97778C6.6274 4.94588 7.00961 3.58665 7.00961 2.66924C7.00961 1.76937 6.22627 0.986457 5.19231 0.986457ZM2.77445 4.60069L1.28472 4.97528C1.20778 4.99462 1.15385 5.0638 1.15385 5.14312V13.4545C1.15385 13.5672 1.25983 13.6499 1.36913 13.6223L4.48452 12.839C4.56145 12.8197 4.61538 12.7505 4.61538 12.6712V7.06765C3.69434 6.35999 3.11097 5.46876 2.77445 4.60069ZM5.76923 7.06765V12.6712C5.76923 12.7505 5.82317 12.8197 5.90008 12.839L9.01546 13.6223C9.12479 13.6499 9.23077 13.5672 9.23077 13.4545V5.14313C9.23077 5.0638 9.17683 4.99462 9.09992 4.97528L7.61019 4.60069C7.27362 5.46876 6.69029 6.35999 5.76923 7.06765ZM13.8462 12.6712C13.8462 12.7505 13.7922 12.8197 13.7153 12.839L10.5999 13.6223C10.4906 13.6499 10.3846 13.5672 10.3846 13.4545V5.14313C10.3846 5.0638 10.4386 4.99463 10.5155 4.97528L13.6308 4.19191C13.7402 4.16443 13.8462 4.24707 13.8462 4.35976V12.6712Z"
                                        fill="#A1A1A1" />
                                </svg>
                                <span class="mx-2">{{ localize('Country') }} :</span>
                                <span>{{ $customer['country'] }}</span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M1.37278 1.37278C2.36587 0.379685 3.85193 0 5.76744 0H10.2326C12.1481 0 13.6341 0.379685 14.6272 1.37278C15.6203 2.36587 16 3.85193 16 5.76744V10.2326C16 12.1481 15.6203 13.6341 14.6272 14.6272C13.6341 15.6203 12.1481 16 10.2326 16H5.76744C3.85193 16 2.36587 15.6203 1.37278 14.6272C0.379685 13.6341 0 12.1481 0 10.2326V5.76744C0 3.85193 0.379685 2.36587 1.37278 1.37278ZM2.16211 2.16211C1.48078 2.84343 1.11628 3.96203 1.11628 5.76744V10.2326C1.11628 12.038 1.48078 13.1566 2.16211 13.8379C2.84343 14.5192 3.96203 14.8837 5.76744 14.8837H10.2326C12.038 14.8837 13.1566 14.5192 13.8379 13.8379C14.5192 13.1566 14.8837 12.038 14.8837 10.2326V5.76744C14.8837 3.96203 14.5192 2.84343 13.8379 2.16211C13.1566 1.48078 12.038 1.11628 10.2326 1.11628H5.76744C3.96203 1.11628 2.84343 1.48078 2.16211 2.16211Z"
                                        fill="#A1A1A1" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M11.5448 5.5277C11.7618 5.7434 11.7615 6.09281 11.5441 6.30813L7.34004 10.4727C7.12281 10.6879 6.77098 10.6878 6.55394 10.4724L4.4556 8.39007C4.23843 8.17456 4.23843 7.82515 4.4556 7.60964C4.67277 7.39413 5.02487 7.39413 5.24204 7.60964L6.94751 9.30208L10.7584 5.52701C10.9758 5.31169 11.3279 5.312 11.5448 5.5277Z"
                                        fill="#A1A1A1" />
                                </svg>
                                <span class="mx-2">{{ localize('status') }} :</span>
                                @if ($customer->status->value === CustomerStatusEnum::ACTIVE->value)
                                    <span class="badge bg-label-success py-2"
                                        role="status">{{ CustomerStatusEnum::ACTIVE->name }}</span>
                                @else
                                    <span class="badge bg-label-danger py-2"
                                        role="status">{{ CustomerStatusEnum::ACTIVE->name }}</span>
                                @endif
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M1.37278 1.37278C2.36587 0.379685 3.85193 0 5.76744 0H10.2326C12.1481 0 13.6341 0.379685 14.6272 1.37278C15.6203 2.36587 16 3.85193 16 5.76744V10.2326C16 12.1481 15.6203 13.6341 14.6272 14.6272C13.6341 15.6203 12.1481 16 10.2326 16H5.76744C3.85193 16 2.36587 15.6203 1.37278 14.6272C0.379685 13.6341 0 12.1481 0 10.2326V5.76744C0 3.85193 0.379685 2.36587 1.37278 1.37278ZM2.16211 2.16211C1.48078 2.84343 1.11628 3.96203 1.11628 5.76744V10.2326C1.11628 12.038 1.48078 13.1566 2.16211 13.8379C2.84343 14.5192 3.96203 14.8837 5.76744 14.8837H10.2326C12.038 14.8837 13.1566 14.5192 13.8379 13.8379C14.5192 13.1566 14.8837 12.038 14.8837 10.2326V5.76744C14.8837 3.96203 14.5192 2.84343 13.8379 2.16211C13.1566 1.48078 12.038 1.11628 10.2326 1.11628H5.76744C3.96203 1.11628 2.84343 1.48078 2.16211 2.16211Z"
                                        fill="#A1A1A1" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M11.5448 5.5277C11.7618 5.7434 11.7615 6.09281 11.5441 6.30813L7.34004 10.4727C7.12281 10.6879 6.77098 10.6878 6.55394 10.4724L4.4556 8.39007C4.23843 8.17456 4.23843 7.82515 4.4556 7.60964C4.67277 7.39413 5.02487 7.39413 5.24204 7.60964L6.94751 9.30208L10.7584 5.52701C10.9758 5.31169 11.3279 5.312 11.5448 5.5277Z"
                                        fill="#A1A1A1" />
                                </svg>
                                <span class="mx-2">Verify Status :</span>
                                @if ($customer->verified_status->value === CustomerVerifyStatusEnum::VERIFIED->value)
                                    <span class="badge bg-label-success py-2"
                                        role="status">{{ CustomerVerifyStatusEnum::VERIFIED->name }}</span>
                                @elseif($customer->verified_status->value === CustomerVerifyStatusEnum::NOT_SUBMIT->value)
                                    <span class="badge bg-label-warning py-2"
                                        role="status">{{ str_replace('_', ' ', CustomerVerifyStatusEnum::NOT_SUBMIT->name) }}</span>
                                @elseif($customer->verified_status->value === CustomerVerifyStatusEnum::CANCELED->value)
                                    <span class="badge bg-label-danger py-2"
                                        role="status">{{ CustomerVerifyStatusEnum::CANCELED->name }}</span>
                                @else
                                    <a href="#" class="badge bg-label-primary py-2">
                                        <span class="spinner-dotted me-2" role="status"> </span>
                                        <span>{{ CustomerVerifyStatusEnum::PROCESSING->name }}</span>
                                    </a>
                                @endif
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M4 0C4.44183 0 4.8 0.358172 4.8 0.8V1.6H11.2V0.8C11.2 0.358172 11.5582 0 12 0C12.4418 0 12.8 0.358172 12.8 0.8V1.60002C13.1672 1.60025 13.4874 1.60251 13.756 1.62446C14.0723 1.6503 14.3869 1.70735 14.6896 1.86159C15.1411 2.09165 15.5083 2.45876 15.7384 2.9104L15.7384 2.9105C15.8927 3.21318 15.9497 3.52772 15.9755 3.84397C16 4.14363 16 4.50743 16 4.92915V12.6708C16 13.0926 16 13.4564 15.9755 13.756C15.9497 14.0723 15.8927 14.3869 15.7384 14.6895C15.5084 15.1411 15.1412 15.5084 14.6895 15.7384C14.3869 15.8927 14.0723 15.9497 13.756 15.9755C13.4564 16 13.0926 16 12.6708 16H3.32915C2.90744 16 2.54363 16 2.24397 15.9755C1.92773 15.9497 1.61318 15.8927 1.3105 15.7384C0.858814 15.5084 0.491665 15.1411 0.261592 14.6896C0.107348 14.3869 0.0502972 14.0723 0.0244572 13.756C-2.60467e-05 13.4564 -1.35957e-05 13.0926 6.86563e-07 12.6708V4.92916C-1.35957e-05 4.50744 -2.60467e-05 4.14363 0.0244573 3.84397C0.050298 3.5277 0.10735 3.21314 0.261581 2.91044M1.6 6.4V12.64C1.6 13.1012 1.60062 13.3991 1.61914 13.6257C1.6369 13.8431 1.66704 13.9237 1.68719 13.9632C1.7639 14.1137 1.88629 14.2361 2.03673 14.3128L2.03683 14.3128C2.07638 14.333 2.15695 14.3631 2.37427 14.3809C2.60094 14.3994 2.89876 14.4 3.36 14.4H12.64C13.1012 14.4 13.3991 14.3994 13.6257 14.3809C13.8431 14.3631 13.9236 14.333 13.9632 14.3128L13.9633 14.3128C14.1137 14.2361 14.2361 14.1137 14.3128 13.9633L14.3128 13.9632C14.333 13.9236 14.3631 13.8431 14.3809 13.6257C14.3994 13.3991 14.4 13.1012 14.4 12.64V6.4H1.6ZM14.3999 4.8H1.60006C1.60041 4.42791 1.60286 4.17358 1.61914 3.97427C1.6369 3.75694 1.66704 3.67637 1.6872 3.63681C1.76389 3.48629 1.88627 3.3639 2.03679 3.2872C2.07635 3.26705 2.15694 3.2369 2.37427 3.21914C2.60094 3.20062 2.89876 3.2 3.36 3.2H12.64C13.1012 3.2 13.3991 3.20062 13.6257 3.21914C13.8431 3.2369 13.9237 3.26704 13.9632 3.28719C14.1137 3.3639 14.2361 3.48629 14.3128 3.63673L14.3128 3.63683C14.333 3.67638 14.3631 3.75694 14.3809 3.97427C14.3971 4.17358 14.3996 4.42791 14.3999 4.8ZM3.2 8.79989C3.20006 8.35806 3.55828 7.99994 4.00011 8L12.0001 8.00112C12.4419 8.00118 12.8001 8.3594 12.8 8.80123C12.7999 9.24306 12.4417 9.60118 11.9999 9.60112L3.99989 9.6C3.55806 9.59994 3.19994 9.24172 3.2 8.79989ZM3.2 11.9999C3.20007 11.5581 3.55829 11.1999 4.00012 11.2L6.66676 11.2004C7.10859 11.2005 7.46671 11.5587 7.46664 12.0005C7.46657 12.4423 7.10835 12.8005 6.66652 12.8004L3.99988 12.8C3.55805 12.7999 3.19993 12.4417 3.2 11.9999Z"
                                        fill="#9B9B9B" />
                                </svg>
                                <span class="mx-2">{{ localize('Joined') }} :</span>
                                <span>{{ get_ymd($customer['created_at']) }}</span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M10.692 1H5.30802C4.1591 1.00635 3.05977 1.46885 2.25187 2.28576C1.44397 3.10268 0.993677 4.20708 1.00007 5.356V10.644C0.993677 11.7929 1.44397 12.8973 2.25187 13.7142C3.05977 14.5311 4.1591 14.9937 5.30802 15H10.692C11.8409 14.9937 12.9402 14.5311 13.748 13.7142C14.556 12.8973 15.0062 11.7929 14.9999 10.644V5.356C15.0062 4.20708 14.556 3.10268 13.748 2.28576C12.9402 1.46885 11.8409 1.00635 10.692 1Z"
                                        stroke="#A1A1A1" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M3.78948 4.84207C3.35346 4.84207 3 5.19553 3 5.63153C3 6.06753 3.35346 6.42099 3.78948 6.42099V4.84207ZM7.99999 6.42099C8.43599 6.42099 8.78947 6.06753 8.78947 5.63153C8.78947 5.19553 8.43599 4.84207 7.99999 4.84207V6.42099ZM7.21051 5.63153C7.21051 6.06753 7.56399 6.42099 7.99999 6.42099C8.43599 6.42099 8.78947 6.06753 8.78947 5.63153H7.21051ZM8.78947 3.78946C8.78947 3.35346 8.43599 3 7.99999 3C7.56399 3 7.21051 3.35346 7.21051 3.78946H8.78947ZM7.99999 4.84207C7.56399 4.84207 7.21051 5.19553 7.21051 5.63153C7.21051 6.06753 7.56399 6.42099 7.99999 6.42099V4.84207ZM11.6842 6.42099C12.1202 6.42099 12.4737 6.06753 12.4737 5.63153C12.4737 5.19553 12.1202 4.84207 11.6842 4.84207V6.42099ZM11.6842 4.84207C11.2482 4.84207 10.8947 5.19553 10.8947 5.63153C10.8947 6.06753 11.2482 6.42099 11.6842 6.42099V4.84207ZM12.2105 6.42099C12.6465 6.42099 13 6.06753 13 5.63153C13 5.19553 12.6465 4.84207 12.2105 4.84207V6.42099ZM12.3302 6.08532C12.5808 5.72861 12.4948 5.2362 12.1381 4.98556C11.7813 4.73492 11.2889 4.82094 11.0382 5.1777L12.3302 6.08532ZM7.23536 9.34547C6.90293 9.62768 6.8623 10.1259 7.14451 10.4582C7.42673 10.7906 7.92494 10.8312 8.25725 10.549L7.23536 9.34547ZM5.15749 11.0528C4.80885 11.3146 4.73848 11.8095 5.00031 12.1582C5.26215 12.5068 5.75704 12.5772 6.10567 12.3153L5.15749 11.0528ZM8.27031 10.5336C8.59641 10.2442 8.6262 9.74525 8.33683 9.41915C8.04757 9.09295 7.54852 9.06316 7.22241 9.35252L8.27031 10.5336ZM7.12525 10.4305C7.39451 10.7734 7.89073 10.8332 8.23378 10.5641C8.57673 10.2948 8.63652 9.79862 8.36736 9.45557L7.12525 10.4305ZM7.14304 7.4175C6.96672 7.01867 6.50051 6.83846 6.10178 7.01477C5.703 7.19109 5.52269 7.65729 5.69904 8.05602L7.14304 7.4175ZM8.37978 9.4761C8.11957 9.12621 7.62504 9.05358 7.27515 9.31379C6.92536 9.57399 6.85262 10.0685 7.11283 10.4184L8.37978 9.4761ZM9.99494 12.9059C10.379 13.1121 10.8577 12.968 11.064 12.5838C11.2702 12.1997 11.1261 11.7211 10.742 11.5148L9.99494 12.9059ZM3.78948 6.42099H7.99999V4.84207H3.78948V6.42099ZM8.78947 5.63153V3.78946H7.21051V5.63153H8.78947ZM7.99999 6.42099H11.6842V4.84207H7.99999V6.42099ZM11.6842 6.42099H12.2105V4.84207H11.6842V6.42099ZM11.0382 5.1777C9.95273 6.72278 8.67483 8.12328 7.23536 9.34547L8.25725 10.549C9.79894 9.2401 11.1676 7.74013 12.3302 6.08532L11.0382 5.1777ZM6.10567 12.3153C6.64335 11.9115 7.4242 11.2842 8.27031 10.5336L7.22241 9.35252C6.40735 10.0756 5.6598 10.6756 5.15749 11.0528L6.10567 12.3153ZM8.36736 9.45557C7.87609 8.8298 7.46483 8.14507 7.14304 7.4175L5.69904 8.05602C6.07388 8.90369 6.55304 9.70136 7.12525 10.4305L8.36736 9.45557ZM7.11283 10.4184C7.87936 11.449 8.86336 12.2983 9.99494 12.9059L10.742 11.5148C9.81452 11.0168 9.0081 10.3207 8.37978 9.4761L7.11283 10.4184Z"
                                        fill="#A1A1A1" />
                                </svg>
                                <span class="mx-2">{{ localize('language') }} :</span>
                                <span>{{ $customer['language'] }}</span>
                            </li>
                        </ul>
                        <p class="mb-3 fs-16 fw-medium">{{ localize('contacts') }}</p>
                        <ul class="list-unstyled mb-4">
                            <li class="d-flex align-items-center mb-3">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.2829 2.15165L6.85077 3.16922C7.36326 4.08751 7.15755 5.29216 6.35036 6.09934C6.35036 6.09934 5.37139 7.07846 7.14644 8.85358C8.92093 10.6281 9.90067 9.64966 9.90067 9.64966C10.7079 8.84247 11.9125 8.63676 12.8308 9.14924L13.8483 9.71712C15.235 10.491 15.3987 12.4356 14.1799 13.6545C13.4476 14.3868 12.5503 14.9567 11.5585 14.9943C9.88895 15.0576 7.05351 14.6351 4.20924 11.7908C1.36499 8.94651 0.942436 6.11108 1.00573 4.44146C1.04333 3.44966 1.6132 2.55246 2.34558 1.82008C3.56442 0.601244 5.50902 0.76501 6.2829 2.15165Z"
                                        stroke="#A1A1A1" stroke-width="1.5" stroke-linecap="round" />
                                </svg>
                                <span class="mx-2">{{ localize('contact') }} :</span>
                                <span>{{ $customer['phone'] }}</span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <svg width="19" height="15" viewBox="0 0 19 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M18 3.78571L14.637 5.62263C12.7621 6.64674 11.8247 7.15884 10.8319 7.3596C9.95314 7.53724 9.04686 7.53724 8.16814 7.3596C7.17538 7.15884 6.23792 6.64674 4.36298 5.62263L1 3.78571M4.02222 14H14.9778C16.0356 14 16.5646 14 16.9687 13.7976C17.3241 13.6196 17.6131 13.3354 17.7941 12.986C18 12.5888 18 12.0687 18 11.0286V3.97143C18 2.93134 18 2.41128 17.7941 2.01402C17.6131 1.66457 17.3241 1.38046 16.9687 1.20242C16.5646 1 16.0356 1 14.9778 1H4.02222C2.96435 1 2.4354 1 2.03135 1.20242C1.67593 1.38046 1.38697 1.66457 1.20588 2.01402C1 2.41128 1 2.93133 1 3.97143V11.0286C1 12.0687 1 12.5888 1.20588 12.986C1.38697 13.3354 1.67593 13.6196 2.03135 13.7976C2.4354 14 2.96434 14 4.02222 14Z"
                                        stroke="#A1A1A1" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                                <span class="mx-2">{{ localize('email') }} :</span>
                                <span>{{ $customer['email'] }}</span>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-8">
                            <div class="row">
                            @if ($customer['customerDocs'])
                                <div class="col-md-6 col-lg-4">
                                    <div class="border-all d-flex flex-column gap-2 h-100 justify-content-between p-2 rounded-3">
                                        <h3 class="fs-18 mb-0 fw-semi-bold text-center">{{ localize('document-1') }}</h3>
                                        <img width="250" height="250" src="{{ $customer['customerDocs']['document1'] ? storage_asset($customer['customerDocs']['document1']) : assets('img/noimage.jpg') }}"
                                             alt="user image" class="rounded" />
                                        <a href="{{ $customer['customerDocs']['document1'] ? storage_asset($customer['customerDocs']['document1']) : assets('img/noimage.jpg') }}"
                                           download="document_1" class="btn btn-primary"><i class="fa fa-download"
                                                                                            aria-hidden="true"></i> <span
                                                class="ms-2">{{ localize('download') }}</span></a>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4">
                                    <div class="border-all d-flex flex-column gap-2 h-100 justify-content-between p-2 rounded-3">
                                        <h3 class="fs-18 mb-0 fw-semi-bold text-center">{{ localize('document-2') }}</h3>
                                        <img width="250" height="250" src="{{ $customer['customerDocs']['document2'] ? storage_asset($customer['customerDocs']['document2']) : assets('img/noimage.jpg') }}"
                                             alt="user image" class="rounded" />
                                        <a href="{{ $customer['customerDocs']['document2'] ? storage_asset($customer['customerDocs']['document2']) : assets('img/noimage.jpg') }}"
                                           download="document_2" class="btn btn-primary"><i class="fa fa-download"
                                                                                            aria-hidden="true"></i> <span
                                                class="ms-2">{{ localize('download') }}</span></a>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4">
                                    <div class="border-all d-flex flex-column gap-2 h-100 justify-content-between p-2 rounded-3">
                                        <h3 class="fs-18 mb-0 fw-semi-bold text-center">{{ localize('Selfie') }}</h3>
                                        <img width="250" height="250" src="{{ $customer['customerDocs']['document3'] ? storage_asset($customer['customerDocs']['document3']) : assets('img/noimage.jpg') }}"
                                             alt="user image" class="rounded" />
                                        <a href="{{ $customer['customerDocs']['document3'] ? storage_asset($customer['customerDocs']['document3']) : assets('img/noimage.jpg') }}"
                                           download="document_3" class="btn btn-primary"><i class="fa fa-download"
                                                                                            aria-hidden="true"></i> <span
                                                class="ms-2">{{ localize('download') }}</span></a>
                                    </div>
                                </div>



                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--customer notification here 8 column-->
</div>
